package org.msh.etbm.services.mobile.sync;

import org.msh.etbm.services.mobile.model.ExamXRayData;
import org.msh.tb.entities.ExamXRay;
import org.msh.tb.entities.TbCase;
import org.msh.tb.entities.Tbunit;

/**
 * Created by rmemoria on 14/9/17.
 */
public class ExamXRayConsumer extends SyncDataConsumerImpl<ExamXRayData, Integer> {

    @Override
    public Integer consume(Tbunit unit, ExamXRayData data) {
        ExamXRay exam = recoverEntity(ExamXRay.class, data.getServerId());

        if (exam.getId() == null) {
            TbCase tbcase = getEntityManager().find(TbCase.class, data.getCaseId());
            exam.setTbcase(tbcase);
        }

        exam.setDate(data.getDate());
        exam.setEvolution(data.getEvolution());
        exam.setPresentation(getFieldValue(data.getPresentation()));
        exam.setComments(data.getComments());

        getEntityManager().persist(exam);

        return data.getServerId() == null ? exam.getId() : null;
    }
}
